/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.udp;

import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.fcs.impl.udp.OutgoingDatagramPortOwner;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Discoverer {
    private static final String TRACE_MASKD = "XFCSDSCD";
    private static final String TRACE_MASKF = "XFCSDSCF";
    private static final String TRACE_MASKT = "XFCSDSCT";
    private OutgoingDatagramPortOwner owner = OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner();
    protected static final String MULTICAST_ADDRESS = "225.4.5.6";

    public void findSubnet() throws FcsException {
        try {
            InetAddress iaddr = InetAddress.getByName("255.255.255.255");
            this.sendPacket(iaddr);
        }
        catch (UnknownHostException uhe) {
            throw new FcsException(uhe);
        }
    }

    public void findMulticast() throws FcsException {
        try {
            InetAddress group = InetAddress.getByName(MULTICAST_ADDRESS);
            this.sendPacket(group);
        }
        catch (UnknownHostException uhe) {
            throw new FcsException(uhe);
        }
    }

    public void findDirect(String hostName) throws FcsException {
        try {
            InetAddress iaddr = InetAddress.getByName(hostName);
            this.sendPacket(iaddr);
        }
        catch (UnknownHostException uhe) {
            throw new FcsException(uhe);
        }
    }

    private void sendPacket(InetAddress iaddr) {
        FcsDatagram query = new FcsDatagram(FcsServer.getFcsServer().getLocalMachineId(), 1);
        DatagramPacket packet = query.asPacket();
        packet.setAddress(iaddr);
        packet.setPort(9900);
        this.owner.send(packet);
    }
}

